INSERT INTO cadastro.quadras (inscricao, setor, numero, setor_id, fields, geoinformation, integration_code, integrated_at, integrated_by, updated_at, updated_by, created_at, created_by, lock_version, ativo)
select distinct on (quadra.iqqua)
	quadra.iqqua as inscricao, 
	substring (quadra.iqqua,1, 5) as setor, 
	quadra.numero as numero,
	(select distinct id from cadastro.setores setores where setores.inscricao = substring (quadra.iqqua,1, 5)) as setor_id, 
	hstore(array[
		'nome', quadra.numero,
		'inscricao_anterior', ''
	]) as fields, 
	quadra.wkb_geometry as geoinformation, 
	null as integration_code, 
	now() as integrated_at, 
	0 as integrated_by, 
	now() as updated_at, 
	1 as updated_by, 
	now() as created_at,
	1 as created_by, 
	0 as lock_version, 
	true as ativo
from public.quadras_novas quadra;
