
INSERT INTO cadastro.territoriais (inscricao, numero, quadra_id, fields, geoinformation, integration_code, integrated_at, integrated_by, updated_at, updated_by, created_at, created_by, lock_version, ativo)
SELECT 
	lote.iqlote as inscricao,
	lote.lote as numero, 
	(select distinct id from cadastro.quadras quadra where quadra.inscricao = substring (lote.iqlote ,1, 9)) as quadra_id, 
	hstore(
		array[
			'inscricao_anterior', '',
			'proc_desmembramento', '',
			'proc_unificacao', '',
			'cod_loteamento', '',
			'loteamento_quadra', '',
			'loteamento_lote', '',
			'parcela_composta', '',
			'parcela_certificada', '',
			'sncr', '',
			'sigef', '',
			'car', '',
			'tipo_ocupacao_id', '',
			'muro_cerca', '',
			'limpeza_lote', '',
			'tipo_situacao_id', '',
			'tipo_pedologia_id', '',
			'tipo_topografia_id', '',
			'tipo_irregularidade_ocupacao_id', '',
			'tipo_irregularidade_lote_id', '',
			'tipo_destinacao_id', '',
			'tipo_localizacao_id', '',
			'area_terreno', '',
			'area_terreno_ri', '',
			'area_tributavel', '',
			'area_preservacao', '',
			'base_legal_preservacao', '',
			'quantidade_testadas', '',
			'area_ocupacao_irregular', ''
		]
	) as fields,
	lote.wkb_geometry as geoinformation,
	null as integration_code,
	now() as integrated_at, 
	0 as integrated_by, 
	now() as updated_at, 
	1 as updated_by, 
	now() as created_at,
	1 as created_by, 
	0 as lock_version,
	true as ativo
	from public.lotes_novos lote 
	
	

